<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Versement extends Model 
{

    protected $table = 'versements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_entreprise', 'id_nm_admin', 'dateDebut', 'dateFin', 'nombreUtilisateur', 'nombreJour', 'nombreVague', 'montant', 'statut');
    protected $visible = array('slug', 'id_nm_admin', 'dateDebut', 'dateFin', 'nombreUtilisateur', 'nombreJour', 'nombreVague', 'montant', 'statut');

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function nm_admin()
    {
        return $this->belongsTo('App\Models\NMadmin', 'id_nm_admin');
    }

}